/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package pakaian;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.sql.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import koneksi.Koneksi;
/**
 *
 * @author Hp
 */
public class barang extends javax.swing.JFrame {
    private final Connection conn = new Koneksi().connect();

    /**
     * Creates new form pelanggan
     */
    public barang() {
        initComponents();
        tableBarang();
        tengah();
    }
     public void tengah()
    {
        Dimension dimmax = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimframe=this.getSize();
        this.setLocation((dimmax.width-dimframe.width)/2,
                        (dimmax.height-dimframe.height)/2);
    }
     protected void aktif() {
    tkdBrg.setEnabled(true);
    tnmBrg.setEnabled(true);
    thrg.setEnabled(true);
    tstok.setEnabled(true);
    tgll.setEnabled(true);
    tidSupplier.setEnabled(true); // Pastikan ini aktif
    tnamaSupplier.setEnabled(true); // Pastikan ini aktif
}

protected void kosong() {
    tkdBrg.setText("");
    tnmBrg.setText("");
    thrg.setText("");
    tstok.setText("");
    tgll.setDate(null); 
    tidSupplier.setText(""); // Kosongkan field ID Supplier
    tnamaSupplier.setText(""); // Kosongkan field Nama Supplier
}

   public void tableBarang() {
    DefaultTableModel model = new DefaultTableModel();
    model.addColumn("Kode Barang");
    model.addColumn("Nama Barang");
    model.addColumn("Harga");
    model.addColumn("Stok");
    model.addColumn("Supplier");
    model.addColumn("Tanggal"); // Menambahkan kolom tanggal

    try {
        String sql = "SELECT * FROM barang";
        Statement stm = conn.createStatement();
        ResultSet res = stm.executeQuery(sql);

        while (res.next()) {
            String tgl = res.getString("tgl");
            String formattedDate = "";
            
            if (tgl != null && !tgl.equals("0000-00-00")) {
                formattedDate = tgl;
            }

            model.addRow(new Object[]{
                res.getString("kd_brg"),
                res.getString("nm_brg"),
                res.getString("hrg"),
                res.getString("stok"),
                res.getString("sup"),
                formattedDate // Tampilkan tanggal atau kosong jika '0000-00-00'
            });
        }

        JtableBarang.setModel(model);
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
    }
}





    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    
    
    private void cariSupplier() {
    String idSupplier = tidSupplier.getText();

    if (idSupplier.isEmpty()) {
        JOptionPane.showMessageDialog(null, "Silakan masukkan ID Supplier.");
        return;
    }

    try {
        String sql = "SELECT nama_sup FROM supplier WHERE id_sup = ?";
        PreparedStatement stat = conn.prepareStatement(sql);
        stat.setString(1, idSupplier);
        ResultSet res = stat.executeQuery();

        if (res.next()) {
            String namaSupplier = res.getString("nama_sup");
            tnamaSupplier.setText(namaSupplier);
            // ID ditemukan, beri notifikasi dan non-aktifkan field
            JOptionPane.showMessageDialog(null, "ID Supplier ditemukan, silakan lanjutkan penginputan data.");
            tidSupplier.setEditable(false); // Non-aktifkan field ID Supplier
            tnamaSupplier.setEditable(false); // Non-aktifkan field Nama Supplier
        } else {
            JOptionPane.showMessageDialog(null, "ID Supplier tidak ditemukan.");
            tnamaSupplier.setText("");
            // Biarkan field ID Supplier tetap bisa diedit
            tidSupplier.setEditable(true); // ID bisa diubah
            tnamaSupplier.setEditable(false); // Nama tetap tidak bisa diubah jika ID tidak ditemukan
        }
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Error: " + e.getMessage());
    }
}





  private void saveBarang() {
    // Format tampilan tanggal
    String tampilan = "yyyy-MM-dd";
    SimpleDateFormat fm = new SimpleDateFormat(tampilan);
    String tanggal = tgll.getDate() != null ? fm.format(tgll.getDate()) : "";

    // Validasi input
    if (tkdBrg.getText().trim().isEmpty() || tnmBrg.getText().trim().isEmpty() ||
        thrg.getText().trim().isEmpty() || tstok.getText().trim().isEmpty() ||
        tnamaSupplier.getText().trim().isEmpty() || tanggal.trim().isEmpty()) {
        JOptionPane.showMessageDialog(null, "Lengkapi semua data sebelum menyimpan.");
        return;
    }

    try {
        String sql = "INSERT INTO barang (kd_brg, nm_brg, hrg, stok, sup, tgl) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement stat = conn.prepareStatement(sql);
        stat.setString(1, tkdBrg.getText());
        stat.setString(2, tnmBrg.getText());
        stat.setDouble(3, Double.parseDouble(thrg.getText()));
        stat.setInt(4, Integer.parseInt(tstok.getText()));
        stat.setString(5, tnamaSupplier.getText());

        // Cek jika tanggal tidak kosong, jika kosong set nilai NULL
        if (tgll.getDate() != null) {
            stat.setDate(6, new java.sql.Date(tgll.getDate().getTime()));
        } else {
            stat.setNull(6, java.sql.Types.DATE);
        }

        stat.executeUpdate();
        JOptionPane.showMessageDialog(null, "Data Berhasil Disimpan");
        tableBarang(); // Refresh table
        kosong(); // Mengosongkan form setelah menyimpan
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Gagal menyimpan data: " + e.getMessage());
    }
}



   private void updateBarang() {
    // Format tampilan tanggal
    String tampilan = "yyyy-MM-dd";
    SimpleDateFormat fm = new SimpleDateFormat(tampilan);
    String tanggal = tgll.getDate() != null ? fm.format(tgll.getDate()) : "";

    // Validasi input
    if (tkdBrg.getText().trim().isEmpty() || tnmBrg.getText().trim().isEmpty() ||
        thrg.getText().trim().isEmpty() || tstok.getText().trim().isEmpty() ||
        tnamaSupplier.getText().trim().isEmpty() || tanggal.trim().isEmpty()) {
        JOptionPane.showMessageDialog(null, "Lengkapi semua data sebelum mengupdate.");
        return;
    }

    try {
        String sql = "UPDATE barang SET nm_brg = ?, hrg = ?, stok = ?, sup = ?, tgl = ? WHERE kd_brg = ?";
        PreparedStatement stat = conn.prepareStatement(sql);
        stat.setString(1, tnmBrg.getText());
        stat.setDouble(2, Double.parseDouble(thrg.getText()));
        stat.setInt(3, Integer.parseInt(tstok.getText()));
        stat.setString(4, tnamaSupplier.getText());

        // Cek jika tanggal tidak kosong, jika kosong set nilai NULL
        if (tgll.getDate() != null) {
            stat.setDate(5, new java.sql.Date(tgll.getDate().getTime()));
        } else {
            stat.setNull(5, java.sql.Types.DATE);
        }

        stat.setString(6, tkdBrg.getText());
        stat.executeUpdate();
        JOptionPane.showMessageDialog(null, "Data Berhasil Diupdate");
        tableBarang(); // Refresh table
        kosong(); // Mengosongkan form setelah update
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Gagal mengupdate data: " + e.getMessage());
    }
}



    private void deleteBarang() {
    // Validasi input
    if (tkdBrg.getText().trim().isEmpty()) {
        JOptionPane.showMessageDialog(null, "Pilih data yang akan dihapus.");
        return;
    }

    try {
        String sql = "DELETE FROM barang WHERE kd_brg = ?";
        PreparedStatement stat = conn.prepareStatement(sql);
        stat.setString(1, tkdBrg.getText());
        stat.executeUpdate();
        JOptionPane.showMessageDialog(null, "Data Berhasil Dihapus");
        tableBarang(); // Refresh table
        kosong(); // Mengosongkan form setelah hapus
    } catch (SQLException e) {
        JOptionPane.showMessageDialog(null, "Gagal menghapus data: " + e.getMessage());
    }
}



    
    
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        tkdBrg = new javax.swing.JTextField();
        tnmBrg = new javax.swing.JTextField();
        thrg = new javax.swing.JTextField();
        tstok = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        JtableBarang = new javax.swing.JTable();
        jButton5 = new javax.swing.JButton();
        tidSupplier = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        tnamaSupplier = new javax.swing.JTextField();
        jButton6 = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        tgll = new com.toedter.calendar.JDateChooser();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel1.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel1.setText("Kode Barang");
        getContentPane().add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 100, -1, -1));

        jLabel2.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel2.setText("Nama Barang");
        getContentPane().add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 146, -1, -1));

        jLabel3.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel3.setText("Stok");
        getContentPane().add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 242, 108, -1));

        jLabel4.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel4.setText("Harga");
        getContentPane().add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 194, 155, -1));

        tkdBrg.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tkdBrgKeyPressed(evt);
            }
        });
        getContentPane().add(tkdBrg, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 100, 279, -1));

        tnmBrg.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tnmBrgKeyPressed(evt);
            }
        });
        getContentPane().add(tnmBrg, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 152, 279, -1));

        thrg.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                thrgKeyPressed(evt);
            }
        });
        getContentPane().add(thrg, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 200, 279, -1));

        tstok.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tstokKeyPressed(evt);
            }
        });
        getContentPane().add(tstok, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 248, 279, -1));

        jButton1.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton1.setText("SAVE");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton1, new org.netbeans.lib.awtextra.AbsoluteConstraints(549, 151, 83, -1));

        jButton2.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton2.setText("UPDATE");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton2, new org.netbeans.lib.awtextra.AbsoluteConstraints(660, 199, 97, -1));

        jButton3.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton3.setText("DELETE");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton3, new org.netbeans.lib.awtextra.AbsoluteConstraints(549, 199, -1, -1));

        jButton4.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton4.setText("KEMBALI");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton4, new org.netbeans.lib.awtextra.AbsoluteConstraints(660, 151, -1, -1));

        JtableBarang.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        JtableBarang.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                JtableBarangMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(JtableBarang);

        getContentPane().add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 426, 751, 330));

        jButton5.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton5.setText("CETAK DATA BARANG");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton5, new org.netbeans.lib.awtextra.AbsoluteConstraints(549, 247, 208, -1));

        tidSupplier.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tidSupplierKeyPressed(evt);
            }
        });
        getContentPane().add(tidSupplier, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 296, 279, -1));

        jLabel6.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel6.setText("Id Supplier");
        getContentPane().add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 290, 129, -1));

        jLabel7.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel7.setText("Supplier");
        getContentPane().add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 338, 108, -1));

        tnamaSupplier.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tnamaSupplierKeyPressed(evt);
            }
        });
        getContentPane().add(tnamaSupplier, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 344, 279, -1));

        jButton6.setFont(new java.awt.Font("Times New Roman", 1, 14)); // NOI18N
        jButton6.setText("CARI");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton6, new org.netbeans.lib.awtextra.AbsoluteConstraints(500, 295, -1, -1));

        jLabel8.setFont(new java.awt.Font("Times New Roman", 1, 24)); // NOI18N
        jLabel8.setText("Tanggal");
        getContentPane().add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(24, 384, 108, -1));

        tgll.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                tgllKeyPressed(evt);
            }
        });
        getContentPane().add(tgll, new org.netbeans.lib.awtextra.AbsoluteConstraints(203, 390, 279, -1));
        getContentPane().add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(174, 35, 173, 58));

        jLabel10.setIcon(new javax.swing.ImageIcon(getClass().getResource("/bg/BARANG-03.jpg"))); // NOI18N
        getContentPane().add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, 800, 770));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        saveBarang();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:
        updateBarang();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // TODO add your handling code here:
        deleteBarang();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        // TODO add your handling code here:
        new menu().show();
        this.dispose();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        // TODO add your handling code here:
        if (JtableBarang.getRowCount() == 0) {
        JOptionPane.showMessageDialog(null, "Data tidak ada yang ingin di print.");
        return;
    }

    try {
        // Mencetak tabel dengan header dan footer
        boolean printComplete = JtableBarang.print(JTable.PrintMode.FIT_WIDTH, 
                new java.text.MessageFormat("Laporan Data Barang Terbaru"), 
                new java.text.MessageFormat("Page {0}"));
        
        if (printComplete) {
            JOptionPane.showMessageDialog(null, "Cetak berhasil.");
        } else {
            JOptionPane.showMessageDialog(null, "Cetak dibatalkan.");
        }
    } catch (java.awt.print.PrinterException e) {
        JOptionPane.showMessageDialog(null, "Gagal mencetak: " + e.getMessage());
    }
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        // TODO add your handling code here:
        cariSupplier();
    }//GEN-LAST:event_jButton6ActionPerformed

    private void JtableBarangMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JtableBarangMouseClicked
        // TODO add your handling code here:
        // Mengambil model tabel dari JTable
DefaultTableModel model = (DefaultTableModel) JtableBarang.getModel();

        // Mendapatkan baris yang dipilih
        int row = JtableBarang.getSelectedRow();

        // Memastikan ada baris yang dipilih
        if (row != -1) {
            // Mengambil data dari tabel berdasarkan kolom
            String kdBrg = model.getValueAt(row, 0).toString();
            String nmBrg = model.getValueAt(row, 1).toString();
            String hrg = model.getValueAt(row, 2).toString();
            String stok = model.getValueAt(row, 3).toString();
            String sup = model.getValueAt(row, 4).toString();
            String tgl = model.getValueAt(row, 5).toString(); // Ambil nilai tanggal dari kolom ke-6

            // Mengisi form input dengan data dari tabel
            tkdBrg.setText(kdBrg);         // JTextField untuk kode barang
            tnmBrg.setText(nmBrg);         // JTextField untuk nama barang
            thrg.setText(hrg);             // JTextField untuk harga
            tstok.setText(stok);           // JTextField untuk stok
            tnamaSupplier.setText(sup);    // JTextField untuk supplier atau JComboBox jika diperlukan

            // Mengisi JDateChooser (atau komponen tanggal lainnya) dengan data tanggal
            try {
                if (tgl.equals("0000-00-00")) {
                    tgll.setDate(null); // Atur nilai tanggal menjadi null jika tanggal kosong
                } else {
                    java.util.Date date = new SimpleDateFormat("yyyy-MM-dd").parse(tgl);
                    tgll.setDate(date); // tgll adalah JDateChooser atau komponen serupa untuk tanggal
                }
            } catch (ParseException e) {
                JOptionPane.showMessageDialog(null, "Error parsing date: " + e.getMessage());
            }
        }
    

    }//GEN-LAST:event_JtableBarangMouseClicked

    private void tkdBrgKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tkdBrgKeyPressed
        // TODO add your handling code here:
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
    tnmBrg.requestFocus();
}
    }//GEN-LAST:event_tkdBrgKeyPressed

    private void thrgKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_thrgKeyPressed
        // TODO add your handling code here:
         if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
    tstok.requestFocus();
         }
    }//GEN-LAST:event_thrgKeyPressed

    private void tstokKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tstokKeyPressed
        // TODO add your handling code here:
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
    tidSupplier.requestFocus();
         }
    }//GEN-LAST:event_tstokKeyPressed

    private void tidSupplierKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tidSupplierKeyPressed
        // TODO add your handling code here:
       
                 if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
     tnamaSupplier.requestFocus();
         }
    }//GEN-LAST:event_tidSupplierKeyPressed

    private void tnamaSupplierKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tnamaSupplierKeyPressed
        // TODO add your handling code here:
       
                     if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
     tgll.requestFocus();
         }
    }//GEN-LAST:event_tnamaSupplierKeyPressed

    private void tgllKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tgllKeyPressed
        // TODO add your handling code here:
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
    tgll.requestFocus();
         }
    }//GEN-LAST:event_tgllKeyPressed

    private void tnmBrgKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_tnmBrgKeyPressed
        // TODO add your handling code here:
        if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
    thrg.requestFocus();
         }
        
    }//GEN-LAST:event_tnmBrgKeyPressed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(barang.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(barang.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(barang.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(barang.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new barang().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable JtableBarang;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JScrollPane jScrollPane1;
    private com.toedter.calendar.JDateChooser tgll;
    private javax.swing.JTextField thrg;
    private javax.swing.JTextField tidSupplier;
    private javax.swing.JTextField tkdBrg;
    private javax.swing.JTextField tnamaSupplier;
    private javax.swing.JTextField tnmBrg;
    private javax.swing.JTextField tstok;
    // End of variables declaration//GEN-END:variables
}
